
/*** 1.   ũƮ ***/

SELECT rownum AS seq
	, NEWID() AS main_code
	, DATEADD(MINUTE, rownum, '2020-01-01 00:00:00.000') AS date 
INTO TB_CURSOR003 
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS rownum
		, a.number
	FROM master..spt_values a JOIN master..spt_values b 
	ON a.type = 'P' AND b.type = 'P' AND a.number <=1000 AND b.number <= 1000
) a

SELECT TOP 100000 main_code AS sub_code
	, CASE WHEN seq % 5 = 1 THEN seq 
	  WHEN seq % 5 = 2 THEN seq 
	  ELSE seq % 100 END AS value 
	, CASE WHEN seq % 5 = 2 THEN seq 
	  ELSE seq % 200 END AS value02 
INTO TB_CURSOR004
FROM TB_CURSOR003
ORDER BY seq

INSERT INTO TB_CURSOR004 SELECT * FROM TB_CURSOR004 WHERE value02 > 100
INSERT INTO TB_CURSOR004 SELECT * FROM TB_CURSOR004 WHERE value02 > 500

CREATE CLUSTERED INDEX CIDX_CURSOR003 ON TB_CURSOR003(main_code)
CREATE CLUSTERED INDEX CIDX_CURSOR004 ON TB_CURSOR004(sub_code)
CREATE INDEX NIDX01_CURSOR004 ON TB_CURSOR004 (value,value02)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

DECLARE @SEQ INT
DECLARE @SUB_CODE VARCHAR(50)
DECLARE @VALUE INT 
DECLARE @VALUE02 INT 

DECLARE CUR CURSOR FOR			
	SELECT DISTINCT value, value02
	FROM TB_CURSOR003 A INNER JOIN TB_CURSOR004 B
	ON A.main_code=B.sub_code

OPEN CUR
FETCH NEXT FROM CUR INTO @VALUE, @VALUE02
WHILE @@FETCH_STATUS = 0
BEGIN
	DECLARE @CNT INT

	SELECT @CNT = COUNT(*)
	FROM TB_CURSOR004
	WHERE value = @VALUE
	AND value02 = @VALUE02

	IF @CNT = 1 
	BEGIN 
		UPDATE A
		SET value = 0
		FROM TB_CURSOR004 A
		WHERE value = @VALUE
		AND value02 = @VALUE02
	END

	ELSE IF @CNT = 2 
	BEGIN 
		UPDATE A
		SET value = -1
		FROM TB_CURSOR004 A
		WHERE value = @VALUE
		AND value02 = @VALUE02
	END

	ELSE IF @CNT = 4 
	BEGIN 
		UPDATE A
		SET value = -2
		FROM TB_CURSOR004 A
		WHERE value = @VALUE
		AND value02 = @VALUE02
	END

FETCH NEXT FROM CUR INTO @VALUE, @VALUE02
	
END	
CLOSE CUR
DEALLOCATE CUR
GO


/*** 6. [TO-BE]   ***/

SELECT B.value, B.value02, COUNT(*) AS CNT
INTO #TEMP_CURSOR2
FROM TB_CURSOR003 A INNER JOIN TB_CURSOR004 B
ON A.main_code=B.sub_code
GROUP BY B.value, B.value02
				
UPDATE A
SET A.value = 0
FROM TB_CURSOR004 A
INNER JOIN #TEMP_CURSOR2 B
ON A.value = B.value 
AND A.value02=B.value02
AND B.CNT = 1

UPDATE A
SET A.value = -1
FROM TB_CURSOR004 A
INNER JOIN #TEMP_CURSOR2 B
ON A.value = B.value 
AND A.value02=B.value02
AND B.CNT = 2

UPDATE A
SET A.value = -2
FROM TB_CURSOR004 A
INNER JOIN #TEMP_CURSOR2 B
ON A.value = B.value 
AND A.value02=B.value02
AND B.CNT = 4
GO

